// Fanuc Interface    - PIC16F13145 : DrB :  3 Jan 25
// GPO Ring Generator - PIC16F13145 : DrB : 24 Mar 24

module FanucLogic(CLK, Sw_n_i, Auto_i, Sprocket_i, Led_n_o, Brake_n_o, Sprocket_0_1_o, Sprocket_1_0_o);
  input  CLK;
  input  Sw_n_i;
  input  Auto_i;
  input  Sprocket_i;
  output Led_n_o;
  output Brake_n_o;
  output Sprocket_0_1_o;
  output Sprocket_1_0_o;
    
  reg    Sw_sr;
  reg    Sw_d1;
  reg    Auto_sr;
  reg    Led_sr;
  reg    Brake_sr;
  reg    Sprocket_sr;
  reg    Sprocket_d1;
  reg    Sprocket_d2;
  reg    Sprocket_d3;
  reg    Sprocket_d4;
  reg    Sprocket_d5;
  reg    Sprocket_d6;
  
  reg    Sprocket_0_1_sr;
  reg    Sprocket_1_0_sr;
  
  assign Brake_n_o      = ~Brake_sr;
  assign Led_n_o        = ~Led_sr;
  assign Sprocket_0_1_o =  Sprocket_0_1_sr;
  assign Sprocket_1_0_o =  Sprocket_1_0_sr;
  
  // Clk runs at ? Hz, divided by two -> ? Hz to Tx output
  
  always @(posedge CLK) // 40 kHz = 25 us 
  begin
  
    Sw_sr  <= ~Sw_n_i;
    Sw_d1  <=  Sw_sr; 
    
    Auto_sr <= Auto_i;
    
    // Sprocket -> 01 and 10 interupts
    
    Sprocket_sr <= Sprocket_i;
    Sprocket_d1 <= Sprocket_sr;    
    Sprocket_d2 <=  Sprocket_d1; 
    Sprocket_d3 <=  Sprocket_d2; 
    Sprocket_d4 <=  Sprocket_d3; 
    Sprocket_d5 <=  Sprocket_d4; 
    Sprocket_d6 <=  Sprocket_d5; 
    
    if (   (Sprocket_sr == 1) 
        && (Sprocket_d1 == 1) 
        && (Sprocket_d2 == 1) 
        && (Sprocket_d3 == 1) 
        && (Sprocket_d4 == 1) 
        && (Sprocket_d5 == 1) 
        && (Sprocket_d6 == 0)) // rising edge : delayed and debounced
         begin
         Sprocket_0_1_sr <=  Auto_i; // require auto to be asserted
         end
         
    else if ((Sprocket_sr == 0) && (Sprocket_d1 == 1)) // falling edge asserted -- not a good place for sampling
         begin
         Sprocket_1_0_sr  <=  ~Auto_i; // require auto to be deasserted (fudge to make synthesis work)
         end
         
    else if (Sprocket_sr == 1) // ongoing assertion
         begin
         Led_sr  <= 1; // Auto ?
         end

    else begin
         Sprocket_0_1_sr <= 0;
         Sprocket_1_0_sr <= 0;
         Led_sr          <= 0; 
         end
    
    
    // Sw -> Brake
    
    if ((Sw_sr == 1) && (Sw_d1 == 0)) // rising edge
         begin
         Brake_sr  <= 1;
         end
         
    else if ((Sw_sr == 0) && (Sw_d1 == 1)) // falling edge
         begin
         Brake_sr  <= 0;
         end
         
    else if (Sw_sr == 1) // ongoing assertion
         begin
         Brake_sr  <= 1;
         end
         
    else begin
         Brake_sr  <= 0; 
         end
  end
  
endmodule