// FanuxInterface main.c // DrB // 6 Jan 24

#include "mcc_generated_files/system/system.h"

static char Interupt_0_1 = 0;
static char PortA_0_1    = 0;
static char PortB_0_1    = 0;
static char PortC_0_1    = 0;

static char Sprocket_0_1 = 0;
static char Octet_0_1    = 0; 

static char Interupt_1_0 = 0;
static char PortA_1_0    = 0;
static char PortB_1_0    = 0;
static char PortC_1_0    = 0;

static char Sprocket_1_0 = 0;
static char Octet_1_0    = 0; 
    
void CLB1_CLB1I0_InterruptHandler (void)
{
    PortA_0_1 = PORTA;
    PortB_0_1 = PORTB;
    PortC_0_1 = PORTC;
    
    Sprocket_0_1 = (PortA_0_1 >> 2) & 1; // arcane ?
    Octet_0_1    = (PortC_0_1 & 0xC0) | ((PortB_0_1 >> 2) & 0x3C) | ((PortA_0_1 >> 4) & 0x3);
    
    Interupt_0_1 = 1;
    return;  
}


void CLB1_CLB1I1_InterruptHandler (void)
{
    PortA_1_0 = PORTA;
    PortB_1_0 = PORTB;
    PortC_1_0 = PORTC;
    
    Sprocket_1_0 = (PortA_1_0 >> 2) & 1; // arcane ?
    Octet_1_0    = (PortC_1_0 & 0xC0) | ((PortB_1_0 >> 2) & 0x3C) | ((PortA_1_0 >> 4) & 0x3);
    
    Interupt_1_0 = 1;
    return;  
}


int main(void)
{
    
    SYSTEM_Initialize();

    CLB1_CLB1I0_SetInterruptHandler (CLB1_CLB1I0_InterruptHandler);
    CLB1_CLB1I1_SetInterruptHandler (CLB1_CLB1I1_InterruptHandler);

    // Enable the Global Interrupts 
    INTERRUPT_GlobalInterruptEnable(); 

    // Enable the Peripheral Interrupts 
    INTERRUPT_PeripheralInterruptEnable(); 

    char Mode = 'X'; // X => hex output, A => printable ascii output, D => diagnostic output
    
    printf ("\r\n\n");
    printf ("Fanuc Interface 1 : DrB : 6 Jan 25 :: Mode %c\r\n", Mode);
    
//    printf ("TRISA  %02X\r\n", TRISA);
//    printf ("LATA   %02X\r\n", LATA);
//    printf ("PORTA  %02X\r\n", PORTA);
//    printf ("WPUA   %02X\r\n", WPUA);
//    printf ("ODCONA %02X\r\n", ODCONA);
//    printf ("ANSELA %02X\r\n", ANSELA);
//
//    printf ("OSCEN    %02X\r\n", OSCEN);
//    printf ("OSCESTAT %02X\r\n", OSCSTAT);
    
    uint8_t cnt = 0;
    
    while (1)
    {
        if (Interupt_0_1 == 1) // valid data, delayed leading edge interupt
        {  switch (Mode)
           {
             case 'A':
                  EUSART1_Write (Octet_0_1); // no filtering
                  break;
             case 'X':
                  printf ("0x%02X\r\n", Octet_0_1);
                  break;
             case 'D':
                  printf ("%d : 0->1 %d %02X %02X %02X >> %02X %X\r\n", 
                          cnt, Interupt_0_1, PortA_0_1, PortB_0_1, PortC_0_1, Octet_0_1, Sprocket_0_1);
                  break;
           }
           cnt = cnt + 1;
           Interupt_0_1 = 0;
        }
        
        if (Interupt_1_0 == 1) // trailing edge interupt - for test
        {  if (Mode == 'D')
              printf ("%d : 1->0 %d %02X %02X %02X >> %02X %X\r\n", 
                      cnt, Interupt_1_0, PortA_1_0, PortB_1_0, PortC_1_0, Octet_1_0, Sprocket_1_0);
           cnt = cnt + 1;
           Interupt_1_0 = 0;
        }
        
        if (EUSART1_IsRxReady ()) // IO trade ?
        {
           char aChar = EUSART1_Read ();
           // EUSART1_Write (aChar);
           switch (aChar)
           {
             case 'a':
             case 'A':
                  Mode = 'A';
                  printf ("Ascii mode selected\r\n");
                  break;
             case 'd':
             case 'D':
                  Mode = 'D';
                  printf ("Diagnostic mode selected\r\n");
                  break;
             case 'x':
             case 'X':
                  Mode = 'X';
                  printf ("Hex mode selected\r\n");
                  break;
             default:
                  printf ("Invalid input '%c' -- discarded\r\n", aChar);
                  break;
           }
         }
    }
}
